<?php $__env->startSection('content'); ?>
<?php if($data): ?>
    <div class="sixteen wide tablet sixteen wide computer column ">
        <div class="ui segment">
            
            <h4 class="ui dividing header teal centered">DETALLE DE PAGOS DE PEDIDOS</h4>
            
            <input type="hidden" id="id_proforma" value="<?php echo e($data->id_proforma); ?>">

            <div class="ui success message">
                <div class="ui equal width grid">
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile six wide tablet three wide computer column message_header">Nombre de Cliente :</div>
                        <div class="sixteen wide mobile ten wide tablet  six wide computer column"><?php echo e(ucwords(mb_strtolower($data->nombre))); ?></div>
                        <div class="sixteen wide mobile six wide tablet three wide computer column message_header">Numero de Documento :</div>
                        <div class="sixteen wide mobile ten wide tablet  four wide computer column"><?php echo e($data->numero_documento); ?></div>
                    </div>
                     <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile six wide tablet  three wide computer column message_header">Direccion de Cliente:</div>
                        <div class="sixteen wide mobile ten wide tablet  thirteen wide computer column"><?php echo e(ucwords(mb_strtolower($data->direccion))); ?></div>
                    </div>
                </div>
            </div>

            <div class="ui info message">
                <div class="ui equal width grid">
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Tipo de Comprobante :</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column"><?php echo e($data->tipo); ?> N° <?php echo e($data->id_proforma); ?>  </div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Fecha de Emision :</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column"><?php echo e($data->fecha_emision); ?></div>
                    </div>
                </div>
            </div>
            

            <div class="ui warning message">
                <div class="ui equal width grid">

                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Total de la Deuda :</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column">S/ <?php echo e($data->total); ?></div>

                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Adelanto Inicial :</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column">S/ <?php echo e($data->adelanto > 0 ? $data->adelanto : '0.00'); ?></div>
                    </div>
                    <div class="row" style="padding-bottom: 0px !important">

                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Total de letras pagadas :</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column">S/ <?php echo e($pagado > 0 ? $pagado : '0.00'); ?></div>

                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Deuda Pendiente :</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column" style="color: red!important">S/ <?php echo e($data->saldo); ?></div>

                    </div>
                </div>
            </div>


            <div class="ui hidden divider"></div>
            <table class="ui table">
                <thead>
                    <tr>
                        <th class="center aligned">Personal que Registro</th>
                        <th class="center aligned">Fecha de Pago</th>
                        <th class="center aligned">Monto Pagado S/</th>
                        <th class="center aligned">Observacion</th>
                        <th class="center aligned">Acciones</th>
                    </tr>
                </thead>
                <tbody id="tbody">
                    <?php $__currentLoopData = $detalle_credito; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $venta): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr data-table="<?php echo e($venta->id_detalle_credito); ?>">
                        <td><?php echo e($venta->usuario->nombres); ?> <?php echo e($venta->usuario->apellidos); ?></td>
                        <td><?php echo e($venta->created_at); ?></td>
                        <td><?php echo e($venta->monto); ?></td>
                        <td><?php echo e($venta->observacion); ?></td>
                        <td>
                            <div class="ui mini vertical animated blue button btn_imprimir_a4" title="Imprimir recibo" data-id="<?php echo e($venta->id_detalle_credito); ?>">
                                <div class="hidden content">A4</div>
                                <div class="visible content"><i class="print alternate icon"></i></div>
                            </div>
                            <div class="ui mini vertical animated blue button btn_imprimir_ticket" title="Imprimir recibo" data-id="<?php echo e($venta->id_detalle_credito); ?>">
                                <div class="hidden content">Ticket</div>
                                <div class="visible content"><i class="print alternate icon"></i></div>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>

            <div class="form_footer" >
                <a class="ui small left  floated default button" href="<?php echo e(URL::previous()); ?>"><i class="arrow left icon"></i>REGRESAR</a>
                
                
                <?php if( count($detalle_credito) > 0): ?>
                
                <div class="ui small right floated violet button btn_imprimir_historial" data-id="<?php echo e($data->id_proforma); ?>"><i class="print icon"></i>Imprimir Historial de Pagos</div>

                <?php endif; ?>

                <?php if($data->saldo > 0): ?>
                <div class="ui small right floated orange button btn_anular_deuda" data-id="<?php echo e($data->id_proforma); ?>"><i class="trash icon"></i>Liquidar deuda</div>
                
                <div class="ui small right floated green button btn_cobrar_letra" data-id="<?php echo e($data->id_proforma); ?>"><i class="dollar sign icon"></i>Registrar un Pago</div>

                <?php endif; ?>
                

                
            </div>  

        </div>
    </div>

    <!--start update modal -->
        <div class="ui small basic modal" id="update_modal">
            <div class="ui icon header"><i class="paper plane icon"></i>Liquidar Deuda</div>
            <div class="content" style="text-align: center; font-size: 16px">
              <p>¿Está seguro que quiere liquidar esta deuda?</p>
            </div>
            <div class="actions">
                <div class="ui red basic cancel inverted button" title="Haga clic para salir"><i class="remove icon"></i>Cancelar</div>
                <div class="ui green ok inverted button" title="Haga clic para anular compra"> <i class="checkmark icon"></i>Liquidar</div>
            </div>
        </div>
    <!--end update modal -->

    <!--start delete modal -->
    <div class="ui small basic modal" id="delete_modal">
        <div class="ui icon header"><i class="trash alternate icon"></i>Eliminar Registro</div>
        <div class="content" style="text-align: center; font-size: 16px">
          <p>¿Está seguro que quiere eliminar este registro del sistema?</p>
        </div>
        <div class="actions">
            <div class="ui red basic cancel inverted button" title="Haga clic para salir"><i class="remove icon"></i>Cancelar</div>
            <div class="ui green ok inverted button" title="Haga clic para eliminar"> <i class="checkmark icon"></i>Eliminar</div>
        </div>
    </div>
    <!--end delete modal -->

    <!--start nuevo producto modal -->
    <div class="ui modal" id="pagar_letra_modal">
        <div class="header">Registrar Pago de Letra</div>     
        <div class="content">
            <div class="ui disabled inverted dimmer" id="loader_producto">
                <div class="ui text loader">Procesando...</div>
            </div>
            <form class="ui form" id="frmLetra" autocomplete="off">
                
                <input type="hidden" name="id_proforma" value="<?php echo e($data->id_proforma); ?>">

                <div class="two fields">
                    <div class="four wide field">
                        <label>Monto de la Letra</label>
                        <div class="ui labeled small input">
                            <label class="ui label">S/</label>
                            <input type="text" name="monto" maxlength="11" value="<?php echo e($data->saldo); ?>">
                        </div>  
                    </div>
                    <div class="twelve wide field">
                        <label>Observacion</label>
                        <div class="ui small input ">
                          <input type="text" name="observacion" maxlength="200" oninput="$.upperCase(this)" value="PAGO DE LETRA DE PEDIDO N° <?php echo e($data->id_proforma); ?>">
                        </div>
                    </div>
                </div>  
    
            </form>
        </div>
        <div class="actions" >
            <div class="ui left floated black right labeled icon deny button" style="margin-bottom: 1em">Cerrar<i class="times icon"></i></div>
            <div class="ui right floated primary button btn_registrar_letra"><i class="plus icon"></i>REGISTRAR</div>
        </div>
    </div>
    <!--end nuevo producto  modal --> 

    <!--start register modal -->
    <div class="ui small basic modal" id="register_modal">
        <div class="ui icon header"><i class="circular inverted white dollar sign icon"></i>Registrar Pago</div>
        <div class="content" style="text-align: center; font-size: 16px">
          <p>¿Desea registrar el pago de letra de esta deuda?</p>
        </div>
        <div class="actions">
            <div class="ui red basic cancel inverted button" title="Haga clic para salir"><i class="remove icon"></i>Cancelar</div>
            <div class="ui green ok inverted button" title="Haga clic para registrar"> <i class="checkmark icon"></i>Registrar</div>
        </div>
    </div>
    <!--end register modal -->

<?php else: ?>
    <div class="sixteen wide tablet fifteen wide computer column ">
        <div class="ui segment">
            <h3 class="ui header black centered">No se puede realizar esta accion</h3>
        </div>
    </div>    
<?php endif; ?>
 
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script src="<?php echo e(asset('js/proforma/detalles_deuda.js')); ?>"></script>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('layout.main', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>