@extends('layout.main')
@section('content')

    <div class="sixteen wide tablet sixteen wide computer column ">
        <div class="ui segment">
            
            <h4 class="ui dividing header teal centered">DETALLES DE RESUMEN DIARIO DE BOLETA</h4>

            <div class="ui info message">
                <div class="ui equal width grid">
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile seven wide tablet  four wide computer column message_header">Tipo de Comprobante  :</div>
                        <div class="sixteen wide mobile nine wide tablet  twelve wide computer column">RESUMEN DIARIO DE BOLETAS</div>
                    </div>
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile seven wide tablet  four wide computer column message_header">N° Resumen Diario :</div>
                        <div class="sixteen wide mobile nine wide tablet  twelve wide computer column">{{ $data->nombre_resumen }}</div>
                    </div>
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile seven wide tablet  four wide computer column message_header">Comprobantes Enviados :</div>
                        <div class="sixteen wide mobile nine wide tablet  twelve wide computer column">{{ $data->tipo_comprobante->nombre }}</div>
                    </div>
                    
                    
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Mensaje de envio a SUNAT :</div>
                        <div class="sixteen wide mobile eight wide tablet  twelve wide computer column">{{ ($data->estado_envio) }} - {{ $data->mensaje_envio }}</div>
                    </div>
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Fecha de Envio:</div>
                        <div class="sixteen wide mobile eight wide tablet  twelve wide computer column">{{ ($data->updated_at) }}</div>
                    </div>
                   
                </div>
            </div>
            
            <div class="ui hidden divider"></div>
            <table class="ui table">
                <thead>
                    <tr>
                        <th class="center aligned">N°</th>
                        <th class="center aligned">Boletas Enviadas</th>
                        <th class="center aligned">Fecha de Emision</th>
                        <th class="center aligned">Subtotal S/</th>
                        <th class="center aligned">Impuesto S/</th>
                        <th class="center aligned">Total S/</th>
                    </tr>
                </thead>
                <tbody id="tbody">
                    <?php /**/ $i = 1 /**/ ?>
                    @foreach ($detalle_resumen as $detalle)
                    <tr data-table="{{ $detalle->id_detalle_venta }}">
                        <td>{{ $i }}</td>
                        @if ($data->id_tipo_comprobante == 2)
                        <td><a href="{{ url('electronico/detalles/'.$detalle->id_venta) }}" title="Clic para ver informacion">{{$detalle->nombre_comprobante}}</a></td>
                        @elseif ($data->id_tipo_comprobante == 3)
                        <td><a href="{{ url('nota/detalles/'.$detalle->id_nota) }}" title="Clic para ver informacion">{{$detalle->nombre_comprobante}}</a></td>
                        @endif
                        <td>{{ $detalle->venta ? $detalle->venta->fecha_venta : $detalle->nota->fecha_emision }}</td>
                        <td>{{ $detalle->subtotal }}</td>
                        <td>{{ $detalle->impuesto }}</td>
                        <td class="positive">{{ $detalle->subtotal + $detalle->impuesto}}</td>
                    </tr>
                    <?php /**/ $i++ /**/ ?>
                    @endforeach
                </tbody>
            </table>

            <div class="form_footer" >
                <a class="ui small left  floated default button" href="{{ URL::previous() }}"><i class="arrow left icon"></i>REGRESAR</a>

             
                @if($data->estado_envio == "NO ENVIADO" || $data->estado_envio == "PENDIENTE" || $data->estado_envio == "RECHAZADO")
                    <div class="ui small right floated red button btn_reenviar" data-id="{{$data->id_resumen}}"><i class="sync alternate icon"></i>Reenviar</div>
                    <div class="ui small right floated orange button btn_cdr" data-id="{{$data->id_resumen}}"><i class="sync alternate icon"></i>Obtener CDR</div>
                @endif 
                @if($data->estado_envio == "ACEPTADO" || $data->estado_envio == "RECHAZADO")
                    <a class="ui small right floated primary button" href="{{ url('../sunat/cdr/resumen/R-'.$empresa->ruc.'-'.$data->nombre_resumen.'.xml') }}" target="_blank"><i class="download icon"></i>Descargar CDR</a>
                @endif
                <a class="ui small right floated green button" href="{{ url('../sunat/xml/resumen/'.$empresa->ruc.'-'.$data->nombre_resumen.'.xml') }}" target="_blank"><i class="download icon"></i>Descargar XML</a>
            </div>  

        </div>
    </div>

@stop

@section('scripts')
    <script src="{{ asset('js/resumen/detalles.js') }}"></script>
@stop


