<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateTrasladosTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('traslados', function (Blueprint $table) {
            $table->integer('id_traslado')->autoIncrement();
            $table->integer('id_local_origen');
            $table->integer('id_local_destino');
            $table->integer('id_usuario');
            $table->string('descripcion', 200)->nullable(); 
            $table->decimal('flete', 9, 2)->nullable(); 
            $table->tinyInteger('estado')->default('1');
            $table->timestamps();

            $table->foreign('id_local_origen')->references('id_local')->on('local'); 
            $table->foreign('id_local_destino')->references('id_local')->on('local'); 
            $table->foreign('id_usuario')->references('id_usuario')->on('usuarios'); 
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('traslados');
    }
}
